/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __SATELLITEDRAWING_H__
#define __SATELLITEDRAWING_H__

#include <QBrush>
#include <QFont>
#include <QPen>
#include <QRect>

/*!
 * Class handles one satellite drawing and defines its position on the plot.
 */
class SatelliteDrawing
{
public:
    /*!
     * Constructor. Gets four parameters.
     * \param is int type variable used for the x -position.
     * \param is int type variable used for the y -position.
     * \param is int type variable used for the width of the drawing.
     * \param is int type variable used for the height of the drawing.
     */
    SatelliteDrawing(int, int, int, int);

    /*!
     * Constructor. Same as previous but parameters are wrapped is the QRect.
     * \param is QRect type variable.
     */
    SatelliteDrawing(QRect &);

    /*!
     * Destructor. No implemention here.
     */
    ~SatelliteDrawing();

    /*!
     * This function initializes all variables and is called from both
     * constructors.
     */
    void init();

    /*!
     * Sets elevation value for the satellite.
     * \param is int type variable. Elevation value is between 0-99 degrees.
     */
    void setElevation(int);

    /*!
     * Sets azimuth value for the satellite.
     * \param is int type variable. Azimuth value is between 0-359 degrees.
     */
    void setAzimuth(int);

    /*!
     * Called by paintevent. Draws circle which describes satellite.
     * Also draws Id text inside the satellite circle.
     * \param is QPainter type. Needed for the drawing.
     */
    void update(QPainter *);


    /*!
     * Sets new Id for the satellite.
     */
    void setId(QString &id);

    /*!
     * Updates drawing area.
     * \param is QRect type. Information of the drawing area is wrapped
     * in QRect.
     */
    void updateArea(QRect &rect);

private:
    /*!
     * Calculates satellites position on the plot by the given azimuth and
     * elevation values.
     */
    void calculatePosition();

    //! Font for the ID numbers
    QFont font;

    //! QPen object for drawing the ID numbers
    QPen idPen;

    //! The satellite is drawn inside this rectangle
    QRect modelRect;

    //! Brush that draws the satellite's image
    QBrush modelStyle;

    //! x-coordinate of the area where the satellite is drawn
    int x;

    //! y-coordinate of the area where the satellite is drawn
    int y;

    //! width of the area where the satellite is drawn
    int width;

    //! height of the area where the satellite is drawn
    int height;

    //! Azimuth angle of the satellite
    int azimuth;

    //! Elevation angle of the satellite
    int elevation;

    //! Satellite's ID number as QString
    QString id;
};

#endif // __SATELLITEDRAWING_H__
