/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __ROUTEDOWNLOADER_H__
#define __ROUTEDOWNLOADER_H__

#include <QString>
#include "googlemapsdownloader.h"

class RouteData;

/*!
 * Download route data from Google Maps using the Google Maps API.
 */
class RouteDownloader : public GoogleMapsDownloader
{
    Q_OBJECT

public:
    /*!
     * Constructor.
     *
     * \param parent The parent widget.
     * \param routeData A routeData object to store the route data in.
     */
    RouteDownloader(QObject *routeData, QObject *parent = 0);

    //! Returns the fromAddress property.
    QString getFromAddress() const { return fromAddress; }

    //! Returns the toAddress property.
    QString getToAddress() const { return toAddress; }

    /*!
     * Download route data.
     *
     * \param fromAddress The starting address.
     * \param toAddress The destination address.
     * \param locale The system locale.
     */
    void downloadData(const QString &fromAddress,
                      const QString &toAddress,
                      const QString &locale);

    //! Get the routeData object.
    RouteData *getRouteData() const { return routeData; }

private:
    //! The address of the web page used to download data.
    const QString downloadAddress;

    //! Teh downloaded data.
    RouteData *routeData;

    //! The starting address.
    QString fromAddress;

    //! The destination address.
    QString toAddress;

private slots:
    //! Reads the route data from the GDirections object in the Javascript code.
    void readDataFromJavaScriptObject();

    //! If the GDirections object reports an error, this is called.
    void downloadFailed();
};

#endif // __ROUTEDOWNLOADER_H__
