/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.con
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __ROUTEDISPLAY_H__
#define __ROUTEDISPLAY_H__

#include <QGraphicsItem>
#include <QObject>

//! Class for displaying route information.
class RouteDisplay : public QObject, public QGraphicsItem
{
    Q_OBJECT

public:
    /*!
     * Constructor.
     *
     * \param width The desired width of the route display area.
     * \param height The desired height of the route display area.
     * \param parent The parent item.
     */
    RouteDisplay(int width, int height, QGraphicsItem *parent = 0);

    //! Destructor.
    ~RouteDisplay();

    //! Returns the width property.
    int getWidth() const { return width; }

    //! Sets the width property.
    void setWidth(int width) { this->width = width; }

    //! Returns the height property.
    int getHeight() const { return height; }

    //! Sets the height property.
    void setHeight(int height) { this->height = height; }

    /*!
     * Get the item's bounding rectangle.
     *
     * \return The bounding rectangle.
     */
    virtual QRectF boundingRect() const;

    /*!
     * Paints the item.
     *
     * \param painter The object that paints the item.
     * \param option Style options for the item.
     * \param widget The widget that is being painted on.
     */
    virtual void paint(QPainter *painter,
                       const QStyleOptionGraphicsItem *option,
                       QWidget *widget);

private:
    //! The color of the item outline.
    const QColor lineColor;

    //! Gradient start color.
    const QColor bgGradientStart;

    //! Gradient stop color.
    const QColor bgGradientStop;

    //! Width of the item.
    int width;

    //! Height of the item.
    int height;
};

#endif // __ROUTEDISPLAY_H__
