/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>
#include <QtGlobal>
#include "routedata.h"

//! Constructor.
RouteData::RouteData(QObject *parent) :
    QObject(parent),
    objectName("routeData")
{
    setObjectName(objectName);
}

//! Destructor.
RouteData::~RouteData()
{
    clear();
}

//! Adds a new waypoint in the waypoints vector.
void RouteData::addWaypoint(Waypoint *waypoint)
{
    waypoints.append(waypoint);
}

//! Removes a waypoint from the waypoints vector.
void RouteData::removeWaypoint(int index)
{
    delete waypoints[index];
    waypoints.remove(index);
}

//! Adds a new line point in the linePoints vector.
void RouteData::addLinePoint(LinePoint *linePoint)
{
    linePoints.append(linePoint);
}

//! Removes a line point from the linePoints vector.
void RouteData::removeLinePoint(int index)
{
    delete linePoints[index];
    linePoints.remove(index);
}

//! Adds a new waypoint in the waypoints vector.
void RouteData::addWaypoint(QString name, qreal longitude, qreal latitude)
{
    Waypoint *wp = new Waypoint();
    wp->setName(name);
    wp->setLongitude(longitude);
    wp->setLatitude(latitude);
    waypoints.append(wp);
}

//! Adds a new line point in the linePoints vector.
void RouteData::addLinePoint(qreal longitude, qreal latitude)
{
    LinePoint *lp = new LinePoint();
    lp->setLongitude(longitude);
    lp->setLatitude(latitude);
    linePoints.append(lp);
}

//! This is called from the JavaScript code when the route is downloaded.
void RouteData::routeDownloadCompleted()
{
    emit routeDataReady();
}

//! This is called from the JavaScript code if the route download failed.
void RouteData::routeDownloadFailed()
{
    emit routeDownloadError();
}

//! Clears the route information.
void RouteData::clear()
{
    name = QString();
    totalDistance = QString();

    for (int i = 0; i < waypoints.size(); i++) {
        delete waypoints[i];
    }

    waypoints.clear();

    for (int i = 0; i < linePoints.size(); i++) {
        delete linePoints[i];
    }

    linePoints.clear();
}
