/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __QUICKMENUBUTTON_H__
#define __QUICKMENUBUTTON_H__

#include <QWidget>
#include <QIcon>

class QPaintEvent;
class QRect;
class QColor;
class QPixmap;

/*!
 * This class one button in the quickmenu.
 */
class QuickMenuButton
{
public:
    /*!
     * Constructor.
     * \param QRect & contains area where icon and drawing is diplayed.
     * \param QString & filename and path for the icon.
     * \param QColor & color for the button.
     * Default value is QColor(0, 100, 255, 100).
     */
    QuickMenuButton(const QRect &, const QString &, const QColor &);

    //! Destructor.
    ~QuickMenuButton();

    /*!
     * Updater. Called always with the owners repaint.
     * \param QRect. Area where drawing and icon is displayed.
     */
    void updateArea(const QRect &);

    /*!
     * Set new mode for the button.
     * \param QIcon::mode -type variable.
     */
    void setMode(const QIcon::Mode mode);

    /*!
     * return mode.
     */
    QIcon::Mode getMode();

    /*!
     * Sets background color for the quickmenu.
     * Default value is QColor(0, 100, 255, 100).
     * \param QColor &.
     */
    void setBackgroundColor(const QColor &);

    /*!
     * Updater. Called always with the owners repaint.
     * \param painter. The painter object.
     */
    void update(QPainter *painter);

    /*!
     * return area where drawing and icon is displayed.
     */
    QRect &getArea();

private:
    const int roundness;

    QIcon::Mode mode;
    QRect area;
    QColor *backgroundColor;
    qreal x;
    qreal y;
    qreal width;
    qreal height;
    QPixmap *image;
    QIcon *icon;
};

#endif // __QUICKMENUBUTTON_H__
