/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QPaintEvent>
#include <QPainter>
#include <QDebug>
#include "quickmenubutton.h"

//! Constructor.
QuickMenuButton::QuickMenuButton(const QRect &rect,
                                 const QString &iconfile,
                                 const QColor &backgroundColor) :
        roundness(20)
{
    this->area = rect;
    this->backgroundColor = new QColor(backgroundColor);
    image = new QPixmap;
    image->load(iconfile);
    icon = new QIcon(iconfile);
    mode = QIcon::Normal;
}

//! Destructor.
QuickMenuButton::~QuickMenuButton()
{
    delete backgroundColor;
    delete image;
    delete icon;
}

//! return area where drawing and icon is displayed.
QRect &QuickMenuButton::getArea()
{
    return area;
}

//! Updater. Called always with the owners repaint.
void QuickMenuButton::updateArea(const QRect &rect)
{
    this->area = rect;
}

//! Set new mode for the button.
void QuickMenuButton::setMode(const QIcon::Mode mode)
{
    this->mode = mode;
}

//! return mode.
QIcon::Mode QuickMenuButton::getMode()
{
    return mode;
}

//! Sets background color for the quickmenu.
void QuickMenuButton::setBackgroundColor(const QColor &color)
{
    this->backgroundColor = new QColor(color);
}

//! Updater. Called always with the owners repaint.
void QuickMenuButton::update(QPainter *painter)
{
    // set focal point for the gradient
    QPoint focalPoints(this->area.x(),
                       this->area.y() + this->area.height());

    // set gradient
    QRadialGradient gradient(this->area.center(),
                             this->area.height(), focalPoints);

    if (mode == QIcon::Selected) {
        gradient.setColorAt(0.2, Qt::white);
        gradient.setColorAt(1, Qt::red);
    }
    else if (mode == QIcon::Normal) {
        gradient.setColorAt(0.2, Qt::white);
        gradient.setColorAt(1, *backgroundColor);
    }

    painter->setBrush(gradient);
    painter->drawRoundRect(area, roundness);
    icon->paint(painter, area, NULL, mode);
}
