/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __POINT_H__
#define __POINT_H__

#include <time.h>

class Point
{
public:
    //! Constructor
    Point();

    /*!
     * Constructor with initial values set
     *
     * \param x x coordinate
     * \param y y coordinate
     * \param altitude Altitude
     * \param time Time
     */
    Point(int x, int y, int altitude, time_t time);

    //! Destructor
    ~Point();

    //! Returns the x coordinate
    int getXCoordinate();

    //! Sets the x coordinate
    void setXCoordinate(int);

    //! Returns the y coordinate
    int getYCoordinate();

    //! Sets the y coordinate
    void setYCoordinate(int);

    //! Returns the altitude
    int getAltitude();

    //! Sets the altitude
    void setAltitude(int);

    //! Returns the time
    time_t getTime();

    //! Sets the time
    void setTime(time_t);

private:
    //! x coordinate
    int x;

    //! y coordinate
    int y;

    //! Altitude
    int altitude;

    //! Time
    time_t time;
};

#endif // __POINT_H__
