/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include "point.h"

//! Constructor
Point::Point()
{
    x = 0;
    altitude = 0;
    y = 0;
    time = 0;
}

//! Constructor with initial values set
Point::Point(int x, int y, int altitude, time_t time) :
        x(x), y(y), altitude(altitude), time(time)
{
}

//! Destructor
Point::~Point()
{
}

//! Returns the x coordinate
int Point::getXCoordinate()
{
    return x;
}

//! Sets the x coordinate
void Point::setXCoordinate(int x)
{
    this->x = x;
}

//! Returns the y coordinate
int Point::getYCoordinate()
{
    return y;
}

//! Sets the y coordinate
void Point::setYCoordinate(int y)
{
    this->y = y;
}

//! Returns the altitude
int Point::getAltitude()
{
    return altitude;
}

//! Sets the altitude
void Point::setAltitude(int altitude)
{
    this->altitude = altitude;
}

//! Returns the time
time_t Point::getTime()
{
    return time;
}

//! Sets the time
void Point::setTime(time_t time)
{
    this->time = time;
}
