/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __POIINFO_H__
#define __POIINFO_H__
#include "displaybox.h"
#include "poi.h"
#include <QObject>
#include <QString>

/*!
 * Class contains needed data for showinf POI info.
 */
class PoiInfo: public DisplayBox, public Poi
{
    Q_OBJECT

public:
    /*!
     * Constructor.
     *
     * \param width Width of the bounding rect of POI info.
     * \param height Height of the bounding rect of POI info.
     * \param parent The parent widget of POI info class.
     */
    PoiInfo(qint32 width, qint32 height);

    //! Destructor.
    ~PoiInfo();

    /*!
     * Sets x coordinate of scene.
     */
    void setX(qint32 x) { this->x = x; }

    /*!
     * Returns x coordinate of scene.
     */
    qint32 getX() const { return x; }

    /*!
     * Sets y coordinate of scene.
     */
    void setY(qint32 y) { this->y = y; }

    /*!
     * Returns y coordinate of scene.
     */
    qint32 getY() const { return y; }

    /*!
     * Set toggled value to POI info.
     */
    void setToggled(bool toggled) { this->toggled = toggled; }

    /*!
     * Returns toggled value of POI info.
     */
    bool getToggled() { return toggled; }

    /*!
     * Sets infoItem to POI info.
     */
    void setInfoItem(QGraphicsTextItem *infoItem) { this->infoItem = infoItem; }

    /*!
     * Returns infoItem of POI info.
     */
    QGraphicsTextItem *getInfoItem() { return infoItem; }

    /*!
     * Sets infoLabel to POI info.
     */
    void setInfoLabel(QGraphicsTextItem *infoLabel) { this->infoLabel = infoLabel; }

    /*!
     * Returns InfoLabel of POI info.
     */
    QGraphicsTextItem *getInfoLabel() { return infoLabel; }

    //! Paints the item.
    virtual void paint(QPainter *painter,
                       const QStyleOptionGraphicsItem *option,
                       QWidget *widget);

private:
    //! color of line
    const QColor lineColor;

    //! color of start gradient
    const QColor bgGradientStart;

    //! color or end gradient
    const QColor bgGradientStop;

    //! roundness of rectangle
    const qint32 rectRoundness;

    /*!
     * X value of scene where POI is.
     */
    qint32 x;

    /*!
     * Y value of scene where POI is.
     */
    qint32 y;

    /*!
     * Toggled value of POI info.
     */
    bool toggled;

    //! Width of rect
    qint32 width;

    //! Height of rect
    qint32 height;

    //! POI info item
    QGraphicsTextItem *infoItem;

    //! POI info label
    QGraphicsTextItem *infoLabel;
};

#endif
