/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QPainter>
#include "poiinfo.h"

//! Constructor
PoiInfo::PoiInfo(qint32 width, qint32 height) :
        DisplayBox(width, height, 0),
        lineColor(0, 100, 255, 150),
        bgGradientStart(255, 255, 255, 250),
        bgGradientStop(255, 255, 255, 250),
        rectRoundness(10),
        width(width),
        height(height)
{

   infoItem = NULL;
   infoLabel = NULL;
}

//! Destructor
PoiInfo::~PoiInfo()
{
}

//! Paints the item.
void PoiInfo::paint(QPainter *painter,
                    const QStyleOptionGraphicsItem *option,
                    QWidget *widget)
{
    Q_UNUSED(option);
    Q_UNUSED(widget);

    QLinearGradient bg(QPointF(0, 0), QPointF(0, height));
    bg.setColorAt(0, bgGradientStart);
    bg.setColorAt(1, bgGradientStop);

    painter->setBrush(QBrush(bg));
    painter->setPen(lineColor);

    painter->drawRoundRect(0, 0, width, height, rectRoundness, rectRoundness);
}
