/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.con
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __POIDOWNLOADER_H__
#define __POIDOWNLOADER_H__

#include <QString>
#include "googlemapsdownloader.h"

class PoiData;

/*!
 * Class is for downloading XML file containing POIs from internet.
 */
class PoiDownloader : public GoogleMapsDownloader
{
    Q_OBJECT

public:
    //! Constructor.
    PoiDownloader(QObject *data, QObject *parent = 0);

    /*!
     * Function for downloading data.
     *
     * \param keyword Search keyword.
     * \param parameter2 Second search parameter (not used).
     * \param parameter3 Third search parameter (not used).
     */
    virtual void downloadData(const QString &keyword,
                              const QString &parameter2 = QString(),
                              const QString &parameter3 = QString());

    //! Return the PoiData object.
    PoiData *getPoiData() const { return poiData; }

private:
    //! The download page address.
    const QString downloadAddress;

    //! The downloaded poi information.
    PoiData *poiData;

private slots:
    //! Reads the downloaded data from the Javascript object.
    virtual void readDataFromJavaScriptObject();

    //! Called in case of a failed download.
    virtual void downloadFailed();
};

#endif
