/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>
#include <QWebFrame>
#include "poidata.h"
#include "poidownloader.h"

//! Constructor.
PoiDownloader::PoiDownloader(QObject *data, QObject *parent) :
    GoogleMapsDownloader(parent),
    downloadAddress("http://qtmapper.garage.maemo.org/poidownload.html")
{
    this->poiData = qobject_cast<PoiData *> (data);

    connect(poiData, SIGNAL(poiDataReady()),
            this, SLOT(readDataFromJavaScriptObject()));
    connect(poiData, SIGNAL(poiDownloadError()),
            this, SLOT(downloadFailed()));
}

//! Function for downloading data.
void PoiDownloader::downloadData(const QString &keyword,
                                 const QString &parameter2,
                                 const QString &parameter3)
{
    Q_UNUSED(parameter2);
    Q_UNUSED(parameter3);

    QString urlString(downloadAddress);
    urlString.append("?query=");
    urlString.append(keyword);

    emit readyToDownload(urlString);
}

//! Reads the downloaded data from the Javascript object.
void PoiDownloader::readDataFromJavaScriptObject()
{
    QString script(
    "var i = 0;"
    "while (searchResult.Placemark[i] != null) {"
    "    var point = new GLatLng(searchResult.Placemark[i]."
    "                            Point.coordinates[1],"
    "                            searchResult.Placemark[i]."
    "                            Point.coordinates[0]);"
    "    var description = new String(searchResult.Placemark[i].address);"
    "    var splitDescription = description.split(',');"
    "    var name = new String(splitDescription[0]);"
    "    poiData.addPoi(point.lat(), point.lng(), name, description);"
    "    i++;"
    "}"
    );

    mainFrame()->evaluateJavaScript(script);

    emit completed();
}

//! Called in case of a failed download.
void PoiDownloader::downloadFailed()
{
    emit failed();
}
