/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef POIDATA_H
#define POIDATA_H

#include <QVector>
#include <QObject>
#include "poi.h"

class PoiData : public QObject
{
    Q_OBJECT

public:
    PoiData(QObject *parent = 0);

    //! Returns the list of POIs.
    QVector<Poi> getDownloadedPois() const { return downloadedPois; }

public slots:
    //! Adds a POI to the downloadedPois list. Called from the Javascript code.
    void addPoi(const double &latitude, const double &longitude,
                const QString &label, const QString &description);

    //! This is called from the JavaScript code if a search was successful.
    void poiDownloadCompleted();

    //! This is called from the JavaScript code if a search failed.
    void poiDownloadFailed();

private:
    //! Name of this object.
    const QString objectName;

    //! A list of the downloaded pois.
    QVector<Poi> downloadedPois;

signals:
    //! Emitted when the download is complete.
    void poiDataReady();

    //! Emitted when there was an error downloading.
    void poiDownloadError();
};

#endif // POIDATA_H
