/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __POICATEGORY_H__
#define __POICATEGORY_H__

#include <QString>

/*!
 * Class represents category of POI (Point Of Interest).
 */
class PoiCategory
{
public:
    /*!
     * Constructor.
     */
    PoiCategory();

    /*!
     * Constructor with parameters.
     * \param enabled Value is POI category enabled or not (so far without
     * any use).
     * \param label Label of POI category.
     * \param description Description of POI category.
     */
    PoiCategory(quint32 enabled, QString label, QString description);

    /*!
     * Destructor.
     */
    ~PoiCategory();

    /*!
     * Sets ID to POI category.
     */
    void setCategoryId(quint32 categoryId) { this->categoryId = categoryId; }

    /*!
     * Gets ID of POI category.
     */
    quint32 getCategoryId() const { return categoryId; }

    /*!
     * Sets value of enabled to POI category.
     */
    void setEnabled(quint32 enabled) { this->enabled = enabled; }

    /*!
     * Gets value of enabled of POI category.
     */
    quint32 getEnabled() const { return enabled; }

    /*!
     * Sets label to POI category.
     */
    void setLabel(QString label) { this->label = label; }

    /*!
     * Gets label of POI category.
     */
    QString getLabel() const { return label; }

    /*!
     * Sets description to POI category.
     */
    void setDescription(QString description) { this->description =
                                               description; }
    /*!
     * Gets description of POI category.
     */
    QString getDescription() const { return description; }

    /*!
     * Test whether POI category has same label than POI category in parameter.
     */
    bool isSimilar(PoiCategory category) const;

private:
    //! ID of POI category.
    quint32 categoryId;

    //! Enabled value of POI category.
    quint32 enabled;

    //! Label of POI category.
    QString label;

    //! Description of POI category
    QString description;
};

#endif
