/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __POICATEGORIES_H__
#define __POICATEGORIES_H__

#include "ui_poicategories.h"
#include "poicategory.h"
#include "QtMapper.h"
#include <QVector>

/*!
 *Class for representing and manipulating POI category data of database.
 */
class PoiCategoriesDialog : public QDialog, public Ui::PoiCategoriesDialog
{
    Q_OBJECT

public:

    /*!
    * Constructor.
    *
    * \param mainWindow Reference to QtMapper.
    * \param parent The parent widget of the dialog, default value 0 is no parent.
    */
    PoiCategoriesDialog(QtMapper &mainWindow, QWidget *parent = 0);
    
    /*!
    * Destructor.
    */
    ~PoiCategoriesDialog();


private:

	//! Width of 1st column
    const int column1Width;
    
    //! Width of 2st column
    const int column2Width;
    
    //! Container for POI categories data.
   	QVector<PoiCategory> categories; 
   	
   	//! Reference to main window.
   	QtMapper &mainWindow;
   	
   	//! Pointer to POI database.
   	PoiDatabase *poiDb;
    
    /*!
     * Sets the data of POI categories to view.
     */
    void setData();

private slots:

    /*!
    * Shows dialog Edit Category and handles updating of database when
    * POI category data is changed.
    */
    void showEditCategoryDialog();
    
    /*!
     * Shows dialog Add Category and handles inserting data to database when
     * POI category is added.
     */
    void showAddCategoryDialog();
    
    /*!
     * Shows dialog Delete Category and handles removing data from database
     * when POI category is deleted.
     */
    void showDeleteCategoryDialog();

};

#endif
