/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __POI_H__
#define __POI_H__

#include <QString>
#include "poicategory.h"

/*!
* Class represents POI (Point Of Interest).
*/
class Poi
{
public:

    /*!
    * Constructor.
    */
    Poi();
    
    /*!
    * Constructor with parameters.
    * \Param latitude Latitude of POI.
    * \Param longitude Longitude of POI.
    * \Param label Label of POI.
    * \Param description Description of POI.
    * \Param category Category of POI.
    */
    Poi(double latitude, double longitude, QString  label,
        QString  description, PoiCategory  category);
        
    /*!
    * Destructor.
    */
    ~Poi();

    /*!
    * Sets ID to poi.
    */
    void setPoiId(quint32 poiId) {
        this->poiId = poiId;
    }
    
    /*!
     * Returns ID of poi.
     */
    quint32 getPoiId() const {
        return poiId;
    }
    
    /*!
     * Sets latitude to poi.
     */
    void setLatitude(double latitude) {
        this->latitude = latitude;
    }
    
    /*!
     * Returns latitude of poi.
     */
    double getLatitude() const {
        return latitude;
    }
    
    /*!
     * Sets longitude to poi.
     */
    void setLongitude(double longitude) {
        this->longitude = longitude;
    }
    
    /*!
     * Returns longitude of poi.
     */
    double getLongitude() const {
        return longitude;
    }
    
    /*!
     * Sets label to poi.
     */
    void setLabel(QString label) {
        this->label = label;
    }
    
    /*!
     * Returns label of poi.
     */
    QString getLabel() const {
        return label;
    }
    
    /*!
     * Sets description to poi.
     */
    void setDescription(QString description) {
        this->description = description;
    }
    /*!
     * Returns description of poi.
     */
    QString getDescription() const {
        return description;
    }
    
    /*!
     * Sets category to poi.
     */
    void setCategory(PoiCategory category) {
        this->category = category;
    }
    
    /*!
     * Returns category of poi.
     */
    PoiCategory getCategory() const {
        return category;
    }
    
    /*!
     * Test weather POI has same latitude, longitude, label and description,
     * than POI in parameter.
     * \param poi POI object.
     * \return True if POI is similar and false if not.
     */
    bool isSimilar(Poi poi) const;

private:

    //! Id of poi.
    quint32 poiId;
    
    //! Latitude of poi.
    double latitude;
    
    //! Longitude of poi.
    double longitude;
    
    //! Label of poi.
    QString label;
    
    //! Description of poi.
    QString description;
    
    //! Category of poi.
    PoiCategory category;
};

#endif
