/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include "poi.h"

//! Constructor.
Poi::Poi()
{

}

//! Constructor with parameters.
Poi::Poi(double latitude, double longitude, QString label,
         QString  description, PoiCategory  category)
{
    this->poiId = poiId;
    this->latitude = latitude;
    this->longitude = longitude;
    this->label = label;
    this->description = description;
    this->category = category;
}

//!Test weather POI has same latitude, longitude, label and description,
//! than POI in parameter.
bool Poi::isSimilar(Poi poi) const
{
    if (poi.getLatitude() == this->latitude &&
        poi.getLongitude() == this->longitude &&
        poi.getLabel() == this->label &&
        poi.getDescription() == this->description) {

        return true;
    }
    return false;
}

//! Destructor.
Poi::~Poi()
{

}

