/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __PLOT_H__
#define __PLOT_H__

class QPainter;
class QRect;

#include <QFont>
#include <QPen>

/*!
 * Class handles satellites' position background drawing.
 */
class Plot
{
public:

    /*!
     * Default constructor.
     */
    Plot();

    /*!
     * Constructor which takes starting measures.
     * \param x X position.
     * \param y Y position.
     * \param width Width of the area.
     * \param height Height of the area.
     */
    Plot(int x, int y, int width, int height);

    /*!
     * Same as the previous but all measures is wrapped in QRect
     * \param QRect Type variable where measures is stored.
     */
    Plot(QRect &rect);

    /*!
     * Called by paintevent. Draws background for the satellites'positions.
     * \param painter Pointer of painter.
     */
    void update(QPainter *);

    /*!
     * Updates measures with the given parameters.
     * \param Reference of QRect.
     */
    void updateArea(QRect &);

    /*!
     * \return Draw area by reference wrapped in QRect.
     */
    QRect &getDrawArea();

private:
    /*!
     * Initializes variables. Called from all constructors.
     */
    void init();

    //! Rectangle where the picture is drawn
    QRect *drawRect;

    //! QPen for drawinf circles
    QPen circle;

    //! Qpen for drawing the lines from center to the circumference
    QPen radiusLines;

    //! x-coordinate for the drawing area
    int x;

    //! y-coordinate for the drawing area
    int y;

    //! width of drawing area's rectangle
    int width;

    //! height of drawing area's rectangle
    int height;

    /*!
     * side length of the actual drawing area, the smaller one
     * of width and height
     */
    int sideLength;

    //! Actual x-coordinate of drawing area, x + width/2 - sideLength/2
    qreal centerXpos;

};

#endif 
