/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef NETWORKACTIVITYINDICATOR_H
#define NETWORKACTIVITYINDICATOR_H

#include <QGraphicsPixmapItem>
#include <QList>

//! An animated image used to indicated network activity.
class NetworkActivityIndicator : public QGraphicsPixmapItem
{
public:
    /*!
     * Constructor.
     *
     * \param parent The parent item.
     */
    NetworkActivityIndicator(QGraphicsItem *parent = 0);

    //! The lowest permitted type value for custom items. Used with type().
    enum { Type = UserType + 1 };

    /*!
     * Advance the animation to the next frame.
     *
     * \param phase See http://doc.trolltech.com/4.4/qgraphicsitem.html#advance
     */
    virtual void advance(int phase);

    /*!
     * \brief Return the type of this item.
     *
     * This method is needed to enable use of the qgraphicsitem_cast().
     *
     * \return The type of this item as an int.
     */
    virtual int type() const { return Type; }

    /*!
     * Paint the item.
     *
     * \param painter Performs the painting.
     * \param option Style options (unused).
     * \param widget The widget that is being painted on (unused).
     */
    virtual void paint(QPainter *painter,
                       const QStyleOptionGraphicsItem *option,
                       QWidget *widget);

    //! Get the value of the active property.
    bool isActive() const { return active; }

    //! Set the value of the active property.
    void setActive(const bool &active) { this->active = active; }

private:
    //! The image file containing the animation frames.
    const QString animationImageFile;

    //! The size of an animation frame (pixels).
    const int frameSize;

    //! Rows of frames in the image file.
    const int rows;

    //! Columns of frames in the image file.
    const int columns;

    //! Index of the first animation frame.
    const int firstFrame;

    //! The total number of frames in the animation.
    const int totalFrames;

    //! A list of the individual animation frames.
    QList<QPixmap> frames;

    //! Index of the currently displayed frame.
    int currentFrame;

    //! Indicates whether this item is currently displayed in the scene.
    bool active;
};

#endif // NETWORKACTIVITYINDICATOR_H
