/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>
#include <QPainter>
#include "networkactivityindicator.h"

//! Constructor.
NetworkActivityIndicator::NetworkActivityIndicator(QGraphicsItem *parent) :
    QGraphicsPixmapItem(parent),
    animationImageFile(":/resources/images/busyanimation.png"),
    frameSize(48),
    rows(6),
    columns(3),
    firstFrame(1),
    totalFrames(rows * columns)
{
    QPixmap pixmap(animationImageFile);

    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < columns; j++) {
            QPixmap clip = pixmap.copy(QRect(j * frameSize, i * frameSize,
                                             frameSize, frameSize));
            frames.append(clip);
        }
    }

    active = false;
    currentFrame = firstFrame;
    setPixmap(frames.at(currentFrame));
}

//! Advances the animation to the next frame.
void NetworkActivityIndicator::advance(int phase)
{
    if (phase) {
        setPixmap(frames.at(++currentFrame));

        if (currentFrame >= totalFrames - firstFrame) {
            currentFrame = firstFrame;
        }
    }
}

//! Paint the item.
void NetworkActivityIndicator::paint(QPainter *painter,
                                     const QStyleOptionGraphicsItem *option,
                                     QWidget *widget)
{
    Q_UNUSED(option);
    Q_UNUSED(widget);

    painter->drawPixmap(static_cast<int> (boundingRect().x()),
                        static_cast<int> (boundingRect().y()), pixmap());
}
