/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef MAPTILEDOWNLOADDIALOG_H
#define MAPTILEDOWNLOADDIALOG_H


#include "ui_downloadmaptiles.h"

class QPushButton;

/*!
 * Class MapTileDownloadDialog is used to create a dialog where user
 * can choose a certain area from which to download map images.
 */
class MapTileDownloadDialog : public QDialog, Ui::MaptileDownloadDialog
{

    Q_OBJECT

public:

    //! Constructor
    /*!
     * \param minZoomLevel The minimum allowed value for zoomLevelSpinBox
     * \param maxZoomLevel The maximum allowed value for zoomLevelSpinBox
     * \param parent The dialog's parent widget
     */
    MapTileDownloadDialog(int minZoomLevel = 0, int maxZoomLevel = 18,
                          QWidget *parent = 0);

    //! Destructor
    ~MapTileDownloadDialog();

    //! Returns the zoomlevel selected in dialog
    int selectedZoomLevel();

    //! returns the fromLatitude as qreal
    qreal fromLatitude();

    //! returns the toLatitude as qreal
    qreal toLatitude();

    //! returns the fromLongitude as qreal
    qreal fromLongitude();

    //! returns the toLongitude as qreal
    qreal toLongitude();

    //! Returns a pointer to "Select area" button in dialog
    QPushButton *getSelectAreaButton();

    //! Sets the value given as parameter to fromLatitudeLineEdit
    void setFromLatitude(qreal latitude);

    //! Sets the value given as parameter to tLatitudeLineEdit
    void setToLatitude(qreal latitude);

    //! Sets the value given as parameter to fromLongitudeLineEdit
    void setFromLongitude(qreal longitude);

    //! Sets the value given as parameter to toLongitudeLineEdit
    void setToLongitude(qreal longitude);

private:

    //! Minimum zoom
    const qint32 minimumZoom;
    
    //! Maximum zoom
    const qint32 maximumZoom;
    
    //! Minimum latitude
    const qreal minimumLatitude;
    
    //! Maximum latitude
    const qreal maximumLatitude;
    
    //! Decimals of latitude and longitude
    const qint32 decimals;
    
    //! Minimum Longitude
    const qreal minimumLongitude;
    
    //! Maximum Longitude
    const qreal maximumLongitude;

private slots:

    //! Checks inputs and if they are ok, enables the Ok button
    void checkLineEditInputs();

signals:

    //! Emitted when ok button is clicked
    void okButtonClicked();

};

#endif
