/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __MAPTILECACHE_H__
#define __MAPTILECACHE_H__

class MapTile;

/*!
 * Class handles inserting map tiles to cache and finding and
 * removing from cache.
 */
class MapTileCache
{
private:

    //! The limit of the cache size in kilobytes.
    const int cacheLimit;

public:

    //! Constructor.
    MapTileCache();

    //! Destructor.
    ~MapTileCache();

    /*!
     * \brief Insert a map tile in the cache.
     *
     * Inserts a map tile in the cache.
     *
     * \param The tile to insert.
     * \return True if the insertion was successful, false otherwise.
     */
    bool insert(MapTile* tile);

    /*!
     * Remove a map tile from the cache.
     *
     * \param The map tile to remove.
     */
    void remove(MapTile* tile);

    /*!
     * \brief Find a map tile in the cache.
     *
     * Tries to find the specified tile in the cache.
     *
     * \param zoomLevel The zoom level of the tile to find.
     * \param mapX The map x coordinate of the tile to find.
     * \param mapY The map y coordinate of the tile to find.
     * \param screenX The screen x coordinate of the tile to find.
     * \param screenY The screen y coordinate of the tile to find.
     * \return If the tile was found, it is returned. If the tile
     * wasn't found, NULL is returned.
     */
    MapTile *find(quint32 zoomLevel, quint32 mapX, quint32 mapY,
                  qint32 screenX, qint32 screenY);
};

#endif
