/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>
#include <QPixmapCache>
#include <QPixmap>
#include <QDebug>
#include <QString>
#include "maprepository.h"
#include "maptile.h"
#include "maptilecache.h"

//! Constructor.
MapTileCache::MapTileCache() :
    cacheLimit(1024 * 10)
{
    QPixmapCache::setCacheLimit(cacheLimit);
}

//! Destructor.
MapTileCache::~MapTileCache()
{
    QPixmapCache::clear();
}

//! Insert a map tile in the cache.
bool MapTileCache::insert(MapTile *tile)
{
    if (QPixmapCache::insert(tile->getKey(), tile->pixmap())) {
        return true;
    }

    return false;
}

//! Remove a map tile from the cache.
void MapTileCache::remove(MapTile *tile)
{
    QPixmapCache::remove(tile->getKey());
}

//! Find a map tile in the cache.
MapTile *MapTileCache::find(quint32 zoom, quint32 mapX,
                            quint32 mapY, qint32 screenX, qint32 screenY)
{
    MapTile* tile = NULL;
    const QString key = QString("/%1/%2/%3").arg(zoom).arg(mapX).arg(mapY);
    QPixmap pm;

    if (QPixmapCache::find(key, pm)) {
        if (!pm.isNull()) {
            tile = new MapTile();
            tile->setPixmap(pm);
            tile->setScreenXCoordinate(screenX);
            tile->setScreenYCoordinate(screenY);
        }
    }

    return tile;
}

