/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QPainter>
#include <QString>
#include "maprepository.h"
#include "maptile.h"

//! Default constructor.
MapTile::MapTile(QGraphicsItem *parent) :
    QGraphicsPixmapItem(parent)
{
}

//! Constructs a MapTile object with given values.
MapTile::MapTile(MapRepository repository, QGraphicsItem *parent) :
    QGraphicsPixmapItem(parent),
    repository(repository)
{
}

//! Constructs a MapTile object with given values.
MapTile::MapTile(MapRepository repository, quint32 zoomLevel,
                 quint32 mapXCoordinate, quint32 mapYCoordinate,
                 QGraphicsItem *parent) :
    QGraphicsPixmapItem(parent),
    repository(repository),
    zoomLevel(zoomLevel),
    mapXCoordinate(mapXCoordinate),
    mapYCoordinate(mapYCoordinate)
{
    key = QString("/%1/%2/%3")
          .arg(zoomLevel)
          .arg(mapXCoordinate)
          .arg(mapYCoordinate);
}

//! Constructs a MapTile object with given values.
MapTile::MapTile(MapRepository repository, quint32 zoomLevel,
                 quint32 mapXCoordinate, quint32 mapYCoordinate,
                 quint32 screenXCoordinate, quint32 screenYCoordinate,
                 QPixmap pixmap, QGraphicsItem *parent) :
    QGraphicsPixmapItem(parent),
    repository(repository),
    zoomLevel(zoomLevel),
    mapXCoordinate(mapXCoordinate),
    mapYCoordinate(mapYCoordinate),
    screenXCoordinate(screenXCoordinate),
    screenYCoordinate(screenYCoordinate)
{
    key = QString("/%1/%2/%3")
          .arg(zoomLevel)
          .arg(mapXCoordinate)
          .arg(mapYCoordinate);
    setPixmap(pixmap);
}
//! Generates a key string.
QString MapTile::createKey(quint32 zoomLevel,
                           quint32 mapXCoordinate,
                           quint32 mapYCoordinate)
{
    this->mapXCoordinate = mapXCoordinate;
    this->mapYCoordinate = mapYCoordinate;
    this->zoomLevel = zoomLevel;

    key = QString("/%1/%2/%3")
          .arg(zoomLevel)
          .arg(mapXCoordinate)
          .arg(mapYCoordinate);

    return key;
}
