/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __MAPSCENE_H__
#define __MAPSCENE_H__

#include <QGraphicsScene>

class QObject;
class QGraphicsSceneMouseEvent;

/*!
 * The MapScene class provides a surface for drawing the maps
 * and other information on screen.
 * Inherits QGraphicsScene.
 */
class MapScene : public QGraphicsScene
{
    Q_OBJECT

public:

    /*!
     * Constructor.
     *
     * \param parent The parent widget.
     */
    MapScene(QObject *parent = 0);

    //! Destructor.
    ~MapScene();

private:

    //! The width of the scene.
    const int sceneWidth;

    //! The height of the scene.
    const int sceneHeight;

protected:

    /*!
     * \brief Mouse wheel event handler.
     *
     * Mouse wheel events that happen in the scene area are handled in this
     * implementation of a virtual method declared in QGraphicsScene.
     *
     * \param e Information about the happened event.
     */
    void wheelEvent(QGraphicsSceneWheelEvent *e);

    /*!
     * \brief Mouse drag event handler.
     *
     * Mouse drag events that happen in the scene area are handled in this
     * implementation of a virtual method declared in QGraphicsScene.
     *
     * \param e Information about the happened event.
     */
    void dragMoveEvent(QGraphicsSceneDragDropEvent *e);

    /*!
     * \brief Mouse button press event handler.
     *
     * Mouse button press events that happen in the scene area are handled in
     * this implementation of a virtual method declared in QGraphicsScene.
     *
     * \param e Information about the happened event.
     */
    void mousePressEvent(QGraphicsSceneMouseEvent* e);

    /*!
     * \brief Mouse button release event handler.
     *
     * Mouse button release events that happen in the scene area are handled
     * in this implementation of a virtual method declared in QGraphicsScene.
     *
     * \param e Information about the happened event.
     */
    void mouseReleaseEvent(QGraphicsSceneMouseEvent* e);

    /*!
     * \brief Mouse move event handler.
     *
     * Mouse move events that happen in the scene area are handled
     * in this implementation of a virtual method declared in QGraphicsScene.
     *
     * \param e Information about the happened event.
     */
    void mouseMoveEvent(QGraphicsSceneMouseEvent* e);

signals:

    /*!
     * Emitted when the mouse was moved in the scene area.
     *
     * \param e Information about the happened event.
     */
    void mouseMoved(QGraphicsSceneMouseEvent *e) ;

    /*!
     * Emitted when the mouse wheel was moved in the scene area.
     *
     * \param e Information about the happened event.
     */
    void mouseWheelMoved(QGraphicsSceneWheelEvent *e);

    /*!
     * Emitted when the mouse was dragged in the scene area.
     *
     * \param e Information about the happened event.
     */
    void mouseDragged(QGraphicsSceneDragDropEvent *e);

    /*!
     * Emitted when a mouse button was released in the scene area.
     *
     * \param e Information about the happened event.
     */
    void mouseButtonReleased(QGraphicsSceneMouseEvent *e);

    /*!
     * Emitted when a mouse button was pressed in the scene area.
     *
     * \param e Information about the happened event.
     */
    void mouseButtonPressed(QGraphicsSceneMouseEvent *e);
};

#endif 
