/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QGraphicsSceneMouseEvent>
#include <QDebug>
#include "mapscene.h"
#include "definitions.h"

//! Constructor.
MapScene::MapScene(QObject *parent) :
    QGraphicsScene(parent),
    sceneWidth(mapTileColumns * mapTileWidth),
    sceneHeight(mapTileRows * mapTileHeight)
{
    setSceneRect(0, 0, sceneWidth, sceneHeight);
}

//! Destructor.
MapScene::~MapScene()
{
}

void MapScene::mouseMoveEvent(QGraphicsSceneMouseEvent* e)
{
    emit mouseMoved(e) ;
}
//! Mouse button press event handler.
void MapScene::mousePressEvent(QGraphicsSceneMouseEvent* e)
{
    emit mouseButtonPressed(e) ;
#ifdef MAPSCENE_DEBUG
    qDebug() << "pressing..." << e->scenePos() ;
#endif
}

//! Mouse button release event handler.
void MapScene::mouseReleaseEvent(QGraphicsSceneMouseEvent* e)
{
    emit mouseButtonReleased(e) ;
#ifdef MAPSCENE_DEBUG
    qDebug() << "releasing..." << e->scenePos() ;
#endif
}

//! Mouse wheel event handler.
void MapScene::wheelEvent(QGraphicsSceneWheelEvent *e)
{
    emit mouseWheelMoved(e);
}

//! Mouse drag event handler.
void MapScene::dragMoveEvent(QGraphicsSceneDragDropEvent *e)
{
    emit mouseDragged(e);
}
