/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __MAPREPOSITORY_H__
#define __MAPREPOSITORY_H__

#include "maprepository.h"

/*!
 * Supported types of map repositories.
 * Defines the order of the x, y, and zoom values
 * in the url used by the repository.
 */
typedef enum {
    repositoryTypeXYZoom,
    repositoryTypeZoomXY

} RepositoryType;

class QString;

/*!
 * Class MapRepository represents a map repository,
 * i.e. a source for map images. The repository has a name
 * and an internet address.
 */
class MapRepository
{
public:

    //! Default constructor.
    MapRepository();

    /*!
     * Constructs a MapRepository object and initializes it with given values.
     *
     * \param name The name of the repository.
     * \param url The URL of the repository.
     * \param imageNameFormat The image name format string.
     * \param dataBaseFileName The name of the database file.
     * \param type The type of the repository.
     */
    MapRepository(QString name, QString url, QString imageNameFormat,
                  QString databaseFileName, RepositoryType type);

    //! Destructor.
    ~MapRepository();

    //! Returns the name property.
    QString getName() const {
        return name;
    }

    //! Sets the name property.
    void setName(QString name) {
        this->name = name;
    }

    //! Returns the url property.
    QString getUrl() const {
        return url;
    }

    //! Sets the url property.
    void setUrl(QString url) {
        this->url = url;
    }

    //! Returns the imageNameFormat property.
    QString getImageNameFormat() const {
        return imageNameFormat;
    }

    //! Sets the imageNameFormat property.
    void setImageNameFormat(QString imageNameFormat) {
        this->imageNameFormat = imageNameFormat;
    }

    //! Returns the database property.
    QString getDatabase() const {
        return database;
    }

    //! Sets the database property.
    void setDatabase(QString database) {
        this->database = database;
    }

    //! Returns the type property.
    RepositoryType getType() const {
        return type;
    }

    //! Sets the type property.
    void setType(RepositoryType type) {
        this->type = type;
    }

private:

    //! The name of the repository.
    QString name;

    //! The URL of the repository.
    QString url;

    /*!
     * A string containing the image name format used in the repository.
     * The string should contain the x, y and zoom values in QString
     * formatting markers (e.g. /%1/%2/%3).
     */
    QString imageNameFormat;

    //! The name of the file where the local database is stored.
    QString database;

    //! The type of the repository.
    RepositoryType type;
};

#endif 
