/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef LONLATBOX_H
#define LONLATBOX_H

/*!
 * Class LonLatBox inherits DisplayBox to display latitude and longitude
 * information.
 */

#include <QColor>
#include <QString>

#include "displaybox.h"

class QGraphicsItem;
class QPainter;
class QStyleOptionGraphicsItem;
class QWidget;

class LonLatBox : public DisplayBox
{

public:
    //! Constructor
    LonLatBox(int width = 0, int height = 0, QGraphicsItem *parent = 0);

    //! Destructor
    ~LonLatBox();

    //! Called by MapView, paints the contents of an item in local coordinates.
    /*!
     * \param painter QPainter object used for painting.
     * \param option Style options for the item, currently not used.
     * \param widget The widget that is being painted on, currently not used.
     */
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget = 0);

    //! Sets new values and updates the coordinate texts
    /*!
     * \param longitude The new longitude value
     * \param latitude The new latitude value
     */
    void setCoordinateValues(qreal longitude, qreal latitude);

    //! Returns the displayed longitude
    qreal getDisplayedLongitude() { return this->displayedLongitude; }

    //! Returns the displayed latitude
    qreal getDisplayedLatitude() { return this->displayedLatitude; }

private:
    //! The displayed longitude
    qreal displayedLongitude;

    //! The displayed latitude
    qreal displayedLatitude;

    //! String object for longitude text
    QString longitudeText;

    //! String object for latitude text
    QString latitudeText;

    //! QFont object used for drawing the longitude and latitude texts
    QFont *font;

    //! Color of the font used for drawing the longitude and latitude texts
    QColor fontColor;

    //! Font family used for drawing the longitude and latitude texts
    const QString fontFamily;

};

#endif // LONLATBOX_H
