/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include "lonlatbox.h"
#include <QPainter>

//! Constructor
LonLatBox::LonLatBox(int width, int height, QGraphicsItem *parent) :
        DisplayBox(width, height, parent),
        fontColor(50, 100, 150),
        fontFamily("sans-serif")

{
    displayedLongitude = 0;
    displayedLatitude = 0;

    longitudeText = tr("Lon: - ");
    latitudeText = tr("Lat: - ");

    font = new QFont(fontFamily, height / 2 - 10);
}

//! Destructor
LonLatBox::~LonLatBox()
{
    delete font;
}

//! Called by MapView, paints the contents of an item in local coordinates.
void LonLatBox::paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
                      QWidget *widget)
{
    DisplayBox::paint(painter, option, widget);

    int height = DisplayBox::getHeight();
    int width = DisplayBox::getWidth();

    painter->setFont(*font);
    painter->setPen(fontColor);

    painter->drawText(width / 25, height / 2 - height / 10, longitudeText);
    painter->drawText(width / 25, height / 2 + height / 10 * 4, latitudeText);
}

//! Sets new values and updates the coordinate texts
void LonLatBox::setCoordinateValues(qreal longitude, qreal latitude)
{
    displayedLongitude = longitude;
    displayedLatitude = latitude;

    longitudeText = tr("Lon: %1").arg(longitude);
    latitudeText = tr("Lat: %1").arg(latitude);
    update();
}
