/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __LINEPOINT_H__
#define __LINEPOINT_H__

#include <QtGlobal>

//! Class holds information of a point to draw a line at.
class LinePoint
{
public:
    //! Constructor.
    LinePoint() {}

    //! Destructor.
    ~LinePoint() {}

    //! Returns the longitude property.
    qreal getLongitude() const { return longitude; }

    //! Sets the longitude property.
    void setLongitude(qreal longitude) { this->longitude = longitude; }

    //! Returns the latitude property.
    qreal getLatitude() const { return latitude; }

    //! Sets the latitude property.
    void setLatitude(qreal latitude) { this->latitude = latitude; }

private:
    //! The longitude at the point.
    qreal longitude;

    //! The latitude at the point.
    qreal latitude;
};

#endif // __LINEPOINT_H__
