/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __INTERNALGPSN810_H__
#define __INTERNALGPSN810_H__

#include <QTcpSocket>
#include "gpsserviceinterface.h"
#include "definitions.h"

#ifdef GPS_N810_IN_USE

class GpsStarter;

/*!
 * This class controls the Nokia N810 internal GPS device.
 * Add the line below to project file when compiling for the maemo:
 * LIBS += -lgps -lgpsbt -lgpsmgr
 */
class InternalGpsN810 : public GpsServiceInterface
{
    Q_OBJECT

public:
    //! Constructor
    InternalGpsN810();

    //! Destructor.
    ~InternalGpsN810();

    //! stops gps when called.
    void stopGps();

    //! Starts gps when called
    void startGps();

    //! restarts gps when called. Can also be used for starting the gps
    void restartGps();

public slots:
    /*!
     * \Brief Reads data from the gps socket
     *
     * Reads data from the gps socket. Parses all incoming nmea sentences into
     * separate sentences.
     * When parsing is done, nmeaSentenceReady(QString) signal will be emitted.
     */
    void readData();

    //! When socket is connected this is called.
    void socketConnected();

    //! When some error in socket connection occurs this function is called.
    /*!
     * \param socketError Information about the error.
     */
    void showError(QAbstractSocket::SocketError socketError);

    //! This function is always called when sockets' state is changed.
    /*!
     * \param socketState State of the socket.
     */
    void readState(QAbstractSocket::SocketState socketState);

    //! When starting or trying to start gps this function is called.
    /*!
     * \param run Ehen true, indicates it is possible start gps.
     *            When false, there is some error.
     * \param error Contains error string from the gps.
     */
    void gpsRunning(bool run, QString error);

private:
    //! Object for the thread which trying to start up gps.
    GpsStarter *startingThread;

    //! socket where data from the gps is coming.
    QTcpSocket *socket;

    //! If gps device is started for the first time
    bool firstStart;

signals:
    /*!
     * This signal is emitted when NMEA sentence is parsed and ready
     * for the later usage.
     * \param nmea The NMEA sentence.
     */
    void nmeaSentenceReady(QString nmea);

    //! This signal is emitted when some error occurs with gps.
    /*!
     * \param error The error message string.
     */
    void errorOccured(QString error);
};

#endif // GPS_N810_IN_USE

#endif // __INTERNALGPSN810_H__
