/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __IMPORTPOISDIALOG_H__
#define __IMPORTPOISDIALOG_H__

#include <QVector>
#include "poicategory.h"
#include "poi.h"
#include "ui_importpois.h"
#include "QtMapper.h"

/*!
 * Class for handling UI when importing POIs.
 */
class ImportPoisDialog : public QDialog, public Ui::ImportPoisDialog
{
    Q_OBJECT

public:
    /*!
     * Constructor
     * \param importedPois Vector of imported pois.
     * \param mainWindow Reference to QtMapper.
     * \param parent Pointer to parent widget.
     */
    ImportPoisDialog(QVector<Poi> importedPois,
                     QtMapper &mainWindow,
                     QWidget *parent = 0);

private:
    //! POI category data container
    QVector<PoiCategory> categories;

    //! Impoted POI data container
    QVector<Poi> importedPois;

    //! Container of POI data from database
    QVector<Poi> pois;

    //! Reference to main window.
    QtMapper &mainWindow;

    //! Pointer to POI database.
    PoiDatabase *poiDb;

private slots:
    /*!
     * Shows Dialog POI categories.
     */
    void showPoiCategoriesDialog();

    /*!
     * Sets labels of POI categories to the combobox.
     */
    void setData();

    /*!
     * Saves imported POIs to database.
     */
    void savePois();
};

#endif
