/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QFile>
#include "helpdialog.h"

//! Constructor
HelpDialog::HelpDialog(QWidget *parent) :
        QDialog(parent),
        englishHelpResource("qrc:/resources/text/help_en.html")
{
    setupUi(this);
    helpBrowser->setOpenExternalLinks(true);
    backButton->setEnabled(helpBrowser->isBackwardAvailable());
    forwardButton->setEnabled(helpBrowser->isForwardAvailable());
    connect(backButton, SIGNAL(clicked()),
            helpBrowser, SLOT(backward()));
    connect(forwardButton, SIGNAL(clicked()),
            helpBrowser, SLOT(forward()));
    connect(helpBrowser, SIGNAL(backwardAvailable(bool)),
            this, SLOT(enableBackButton(bool)));
    connect(helpBrowser, SIGNAL(forwardAvailable(bool)),
            this, SLOT(enableForwardButton(bool)));

    helpBrowser->setSource(QUrl(englishHelpResource));
}

//! Enable or disable the back button.
void HelpDialog::enableBackButton(bool enable)
{
    backButton->setEnabled(enable);
}

//! Enable or disable the forward button.
void HelpDialog::enableForwardButton(bool enable)
{
    forwardButton->setEnabled(enable);
}
