/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __GPXHANDLER_H__
#define __GPXHANDLER_H__

#include "poi.h"
#include <QVector>
#include <QXmlDefaultHandler>

/*!
 * Class is for handling GPX data.
 */
class GpxHandler : public QXmlDefaultHandler
{
public:
    /*!
     * Constructor.
     * \param data SearchLocationInfo object.
     */
    GpxHandler(QVector<Poi> &pois);

    /*!
     * Destructor
     */
    ~GpxHandler();

    /*!
     * Method is called when parser finds start element of XML file.
     * Saves parameters of XML file to POI object.
     * \param namespaceURI The namespace uri of the parsed document.
     * \param localName The local name of the parsed document.
     * \param qName The tag name of the parsed document.
     * \param attributes The attributes of the parsed document.
     * \return boolean true if file is GPX file.
     */
    bool startElement(const QString &namespaceURI, const QString &localName,
                      const QString &qName, const QXmlAttributes &attributes);

    /*!
     * Method is called when parser finds end element of XML file.
     * Method saves character data of elements to POI object and inserts
     * POI object to vector.
     * \param namespaceURI The namespace uri of the parsed document.
     * \param localName The local name of the parsed document.
     * \param qName The tag name of the parsed document.
     * \return boolean true.
     */
    bool endElement(const QString &namespaceURI, const QString &localName,
                    const QString &qName);

    /*!
     * Method is called when parser finds character data from GPX file.
     * Method saves character data temporarily.
     */
    bool characters(const QString &str);

private:
    //! POI data
    Poi poi;

    //! POI data container
    QVector<Poi> &pois;

    //! current character data
    QString currentText;

    //! for checking validity of GPX file
    bool metGpxTag;
};

#endif
