/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include "gpxhandler.h"
#include "poi.h"

//! Constructor
GpxHandler::GpxHandler(QVector<Poi> &pois) :
        pois(pois)
{
    metGpxTag = false;
}

//! Method is called when parser finds start element of XML file
bool GpxHandler::startElement(const QString &,
                              const QString &,
                              const QString &qName,
                              const QXmlAttributes &attributes)
{
    const QString gpxTag = "gpx";
    const QString wptTag = "wpt";
    const QString firstAttribute = "lat";
    const QString secondAttribute = "lon";

    if (!metGpxTag && qName != gpxTag) {
        return false;
    }

    if (qName == gpxTag) {
        metGpxTag = true;
    }
    else if (qName == wptTag) {
        poi.setLatitude(attributes.value(firstAttribute).toDouble());
        poi.setLongitude(attributes.value(secondAttribute).toDouble());
    }
    
    currentText.clear();
    return true;
}

//! Method is called when parser finds end element of XML file
bool GpxHandler::endElement(const QString &,
                            const QString &,
                            const QString &qName)
{
    const QString nameTag = "name";
    const QString descTag = "desc";

    if (qName == nameTag) {
        poi.setLabel(currentText);
    }
    else if (qName == descTag) {
        poi.setDescription(currentText);
        pois.append(poi);
    }

    currentText.clear();
    return true;
}

//! Method is called when parser finds character data from GPX file
bool GpxHandler::characters(const QString &str)
{
    currentText += str;
    return true;
}

//! Destructor
GpxHandler::~GpxHandler()
{
}
