/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __GPSSTARTER_H__
#define __GPSSTARTER_H__

#include "definitions.h"

#ifdef GPS_N810_IN_USE

#include <QObject>
#include <QThread>

/*!
 * This class creates a thread for starting up the N810 internal gps.
 */
class GpsStarter : public QThread
{
    Q_OBJECT

public:
    //! Constructor.
    GpsStarter();

    //! Destructor
    ~GpsStarter();

    //! Starts the gps manager.
    void run();

private:
    //! Bluetooth gps debug level, bigger value <=> more information from device
    const int gpsBtDebugLevel;

    //! Gps daemon debug level, bigger value <=> more information from device
    const int gpsDaemonDebugLevel;

    /*!
     * When start command is given to gps daemon, this is the time
     * in seconds that we wait before making a new attempt
     */
    const int gpsConnectionTryingTimeOut;

    //! Maximum number of connection attempts
    const int gpsConnectionMaxTryOuts;

    //! Holds the state of the gps manager
    int gpsBtState;

signals:
    /*!
     * Signals if the gps manager running or not?
     *
     * \param running Whether the gps manager is running or not
     * \param description Description if required, for example in the case
     *        of an error.
     */
    void gpsrunning(bool running, QString description);

};

#endif // GPS_N810_IN_USE

#endif // __GPSSTARTER_H__
