/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __GPSSERVICEINTERFACE_H__
#define __GPSSERVICEINTERFACE_H__

#include <QObject>

/*!
 * This is an interface class for the all gps devices which are supported by
 * QtMapper. List of classes and files involved to gps device side:
 * - gpsserial.cpp/.h
 * - serialport.cpp/.h
 * - internalgpsn810.cpp/.h
 *     -gpsstarter.cpp/.h
 *
 * When compiling for N810, uncomment #define GPS_N810_IN_USE from definitions.h
 * and add this line to .pro file:
 * LIBS += -lgps -lgpsbt -lgpsmgr
 */
class GpsServiceInterface : public QObject
{

    Q_OBJECT

public:
    //! Starts the gps device, must be implemented in the inheriting class
    virtual void startGps() = 0;

    //! Stops the gps device, must be implemented in the inheriting class
    virtual void stopGps() = 0;

    //! Restarts the gps device, must be implemented in the inheriting class
    virtual void restartGps() = 0;

signals:
    /*!
     * Emitted if an error occurs. Must be implemented in the inheriting class
     *
     * \param error Description of the error that occurred
     */
    virtual void errorOccured(QString error) = 0;

    /*!
     * Emitted when an NMEA sentence is available. Must be implemented in the
     * inheriting class
     *
     * \param nmea The NMEA sentence from the gps device.
     */
    virtual void nmeaSentenceReady(QString nmea) = 0;
};

#endif // __GPSSERVICEINTERFACE_H__
