/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __GPSSERIAL_H__
#define __GPSSERIAL_H__

#include "definitions.h"

#ifdef GPS_SERIAL_IN_USE

#include "gpsserviceinterface.h"

class SerialPort;

/**
 * Class GpsSerial operates the serial port based gps device
 */
class GpsSerial : public GpsServiceInterface
{
    Q_OBJECT

public:
    //! Constructor
    GpsSerial();

    //! Destructor
    ~GpsSerial();

    //! starts the serial port gps device
    void startGps();

    //! stops the serial port gps device
    void stopGps();

    //! restarts ie. stops and starts the serial port gps device
    void restartGps();

signals:
    /*!
     * Emitted if an error occurs.
     *
     * \param error Description of error as QString
     */
    void errorOccured(QString error);

    /*!
     * Emitted when a NMEA sentence is ready
     *
     * \param nme The NMEA sentence as QString
     */
    void nmeaSentenceReady(QString nmea);

private:

    //! Gps commands
    typedef enum {
        gpsStop, /*!< starts the gps device */
        gpsStart /*!< stops the gps device */
    } gpsCommand;

    //! Object for the serialport- class
    SerialPort *serialPort;

    /*!
     * Sends messages to the serialport based gps device
     *
     * \param operation The operation to be performed, default is to stop gps.
     */
    void sendMessage(gpsCommand operation = gpsStop);

private slots:

    //! Reads the messages sent by the gps device
    /*!
     * Reads the messages sent by the gps device. Emits the messages
     * as an nmeaSentenceReady(QString) signal.
     */
    void receiveMessage();

};

#endif // GPS_SERIAL_IN_USE

#endif // __GPSDESKTOP_H__
