/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include "gpsserial.h"

#ifdef GPS_SERIAL_IN_USE

#include "serialport.h"

//! Constructor
GpsSerial::GpsSerial()
{
    serialPort = new SerialPort();
    connect(serialPort, SIGNAL(readyRead()), this, SLOT(receiveMessage()));
    serialPort->open(QIODevice::ReadWrite);

    this->sendMessage(gpsStart);
}

//! Destructor
GpsSerial::~GpsSerial()
{
    this->sendMessage(gpsStop);
    serialPort->close();

    delete serialPort;
}

//! starts the serial port gps device
void GpsSerial::startGps()
{
    this->sendMessage(gpsStart);
}

//! stops the serial port gps device
void GpsSerial::stopGps()
{
    this->sendMessage(gpsStop);
}

//! restarts ie stops and starts the serial port gps device
void GpsSerial::restartGps()
{
    this->stopGps();
    this->startGps();
}

//! sends messages to the serialport based gps device
void GpsSerial::sendMessage(gpsCommand operation)
{
    const QString endLineChars("\r\n");
    const qint64 writeError = -1;
    qint64 written = 0;
    QString *message;

    if (operation == gpsStop) {
        message = new QString(messageDownForGps);
    }
    else if (operation == gpsStart) {
        message = new QString(messageForGps);
    }
    else {
        return;
    }

    message->append(endLineChars);

    if ((written = serialPort->write(message->toAscii(),
                                     message->length())) == writeError) {
        emit errorOccured("Failed to write to serial port.");
    }

    delete message;
}

//! Reads the messages sent by the gps device
void GpsSerial::receiveMessage()
{
    const int maxChars = 1024 + 1;
    char data[maxChars];

    qint64 bytes = serialPort->bytesAvailable();

    if (bytes > 0 && bytes < maxChars) {

        serialPort->read(data, bytes);
        data[bytes] = '\0';

        QString nmea(data);
        emit nmeaSentenceReady(nmea);
    }
}

#endif // GPS_SERIAL_IN_USE
