/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __GPSSATELLITEDATA_H__
#define __GPSSATELLITEDATA_H__

#include <QObject>

/*!
 * GpsSatelliteData -class is used for storing information about one satellite.
 */
class GpsSatelliteData : public QObject
{
    Q_OBJECT

public:
    //! Constructor
    GpsSatelliteData() ;

    //! Set satellite ID
    void setPrn(int prn) { this->prn = prn; }

    //! Returns the satellite ID stored in class variable prn
    int getPrn() const { return this->prn; }

    //! Set elevation angle of satellite (0-90 degrees)
    void setElevation(int elevation) { this->elevation = elevation; }

    //! Returns the satellite elevation
    int getElevation() const { return this->elevation; }

    //! Set azimuth angle of the satellite (0-359 degrees)
    void setAzimuth(int azimuth) { this->azimuth = azimuth; }

    //! Returns satellite's azimuth angle
    int getAzimuth() const { return this->azimuth; }


    //! Sets Signal to noise ratio and emits snrChanged signal.
    /*!
     * \param snr The new signal-to-noise ratio
     */
    void setSnr(int snr);

    //! Return satellite's signal to noise ratio store in class variable snr
    int getSnr() const { return this->snr; }

    //! Set all class variables to zero.
    void reset();

private:
    //! Signal to noise ratio
    int snr;

    //! Satellite ID
    int prn;

    //! Satellite elevation angle
    int elevation;

    //! Azimuth angle of satellite
    int azimuth;

signals:
    //! When signal to noise ratio is set, this signal is emitted.
    /*!
     * \param prn The satellite ID number
     * \param snr Signal-to-noise ratio
     */
    void snrChanged(int prn, int snr);

};

#endif // __GPSSATELLITEDATA_H__
