/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __GPSEMULATOR_H__
#define __GPSEMULATOR_H__

#include "definitions.h"

#ifdef GPS_EMULATOR_IN_USE

#include "gpsserviceinterface.h"

#include <QVector>
#include <QFile>
#include <QString>

class QTimer;

/*!
* Class is for emulating GPS device
*/
class GpsEmulator : public GpsServiceInterface 
{
   Q_OBJECT
   
public:
   
    //! Constructor
    GpsEmulator();
    
    //! Destructor
    ~GpsEmulator();
    
    //! Empty
    void startGps();

    //! Empty
    void stopGps();
  
    //! Empty
    void restartGps();

signals:

    /*!
     * Emitted if an error occurs.
     *
     * \param error Description of error as QString
     */
    void errorOccured(QString error);

    /*!
     * Emitted when a NMEA sentence is ready
     *
     * \param nme The NMEA sentence as QString
     */
    void nmeaSentenceReady(QString nmea);
    
private slots:

    /*!
    * Reads nmea messages from file
    */
    void receiveMessage();
    
    /*!
    * Function separate nmea sentences from string
    */
    void separateSentencesFromString();
    
    /*!
    * ! Function sends nmea sentence forward
    */
    void sendSentence();
   
private:

    //! Timer for sending messages
    QTimer *sendingTimer;
    
    //! File for nmea sentences
    QFile *nmeaFile;
    
    //! Sending interval of sentence
    const qint32 sendingInterval;
    
    //! String for nmea sentences
    QString nmeaString;
    
    //! Vector for nmea sentences
    QVector<QString> sentences;
    
    //! For keeping track of sentence
    qint32 indexOfSentence;
    
    //! Path of file that contains nmea sentences
    const QString filePath;
    
};

#endif 

#endif // GPS_EMULATOR_IN_USE

