/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include "gpsemulator.h"

#include <QTimer>
#include <QDebug>
#include <QByteArray>

#ifdef GPS_EMULATOR_IN_USE

//! Constructor
GpsEmulator::GpsEmulator() :
 sendingInterval(1000),
 filePath("./nmeaFile")
{
    nmeaFile = new QFile(filePath);
    nmeaFile->open(QIODevice::ReadWrite);
    sendingTimer = new QTimer(this);
    connect(sendingTimer, SIGNAL(timeout()), this, SLOT(sendSentence()));
    sendingTimer->setInterval(sendingInterval);
    receiveMessage();
    indexOfSentence = 0;
}

//! Destructor
GpsEmulator::~GpsEmulator()
{
    nmeaFile->close();
    delete nmeaFile;
}

//! Empty
void GpsEmulator::startGps()
{
   
}

//! Empty
void GpsEmulator::stopGps()
{
   
}

//! Empty
void GpsEmulator::restartGps()
{
    
}

//! Reads the messages sent by the gps device
void GpsEmulator::receiveMessage()
{
    qint64 bytes = nmeaFile->bytesAvailable();
  
    if (bytes > 0 ) {
        QByteArray nmeaArray = nmeaFile->readAll();
        nmeaString.append(QString(nmeaArray));
        separateSentencesFromString();
    }
}

//! Function separate nmea sentences from string
void GpsEmulator::separateSentencesFromString()
{
    
    bool end = false;
    qint32 i = 0;
        
    while (end == false) {
       
       if (nmeaString.section('\n', i, i) == "") {
           end = true;
       }
       else {
          sentences.append(nmeaString.section('\n', i, i));
          i++; 
       }
    }
    
    if (sentences.count() > 0) {
        sendingTimer->start();
    }
}

//! Function sends sentence forward
void GpsEmulator::sendSentence()
{
    
    if (indexOfSentence < sentences.count() - 5) {
        
        for (qint32 i = 0; i <= 5; i++) {
            emit nmeaSentenceReady(sentences.at(indexOfSentence));
            indexOfSentence++;
        }
        
    }
    else {
        sendingTimer->stop();
    }
}

#endif // GPS_EMULATOR_IN_USE

