/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __GOOGLEMAPSDOWNLOADER_H__
#define __GOOGLEMAPSDOWNLOADER_H__

#include <QNetworkReply>
#include <QString>
#include <QWebPage>

/*!
 * Download data from Google Maps using the Google Maps API.
 */
class GoogleMapsDownloader : public QWebPage
{
    Q_OBJECT

public:
    /*!
     * Constructor.
     *
     * \param data An object to store the downloaded data in.
     * \param parent The parent widget.
     */
    GoogleMapsDownloader(QObject *data, QObject *parent = 0);

    /*!
     * Download data from Google Maps.
     *
     * \param firstSearchParameter First search parameter.
     * \param secondSearchParameter Second search parameter.
     * \param thirdSearchParameter Third search parameter.
     */
    virtual void downloadData(const QString &firstSearchParameter = QString(),
                              const QString &secondSearchParameter = QString(),
                              const QString &thirdSearchParameter = QString())
                              = 0;

private slots:
    /*!
     * Called when a network request finishes.
     *
     * \param reply The reply to the request.
     */
    void networkRequestFinished(QNetworkReply *reply);

    //! Reads the downloaded data from the Javascript object.
    virtual void readDataFromJavaScriptObject() = 0;

    //! Called in case of a failed download.
    virtual void downloadFailed() = 0;

signals:
    /*!
     * Tells the web view to start downloading.
     *
     * \param url The URL of the web page to load.
     */
    void readyToDownload(QString &url);

    //! Emitted on a successful download.
    void completed();

    /*!
     * Emitted on a failed download.
     *
     * \param errorCode The HTTP error code.
     * \param error A text description of the error.
     */
    void failed(int errorCode = QNetworkReply::NoError,
                const QString &error = QString());
};

#endif // __GOOGLEMAPSDOWNLOADER_H__
