/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef EDITREPOSITORYDIALOG_H
#define EDITREPOSITORYDIALOG_H

#include <QDialog>
#include "ui_editrepository.h"

//! A map repository editing dialog.
class EditRepositoryDialog : public QDialog, Ui::EditRepositoryDialog
{
    Q_OBJECT

public:
    /*!
     * Constructor.
     *
     * \param parent The parent widget (default = no parent).
     */
    EditRepositoryDialog(QWidget *parent = 0);

    //! Destructor.
    ~EditRepositoryDialog();

    /*!
     * Sets the text in the name line edit box.
     *
     * \param text The new text.
     */
    void setNameText(const QString &text) {
        lineEditName->setText(text);
    }

    /*!
     * Gets the text in the name line edit box.
     *
     * \return The text in the name line edit box.
     */
    QString nameText() {
        return lineEditName->text();
    }

    /*!
     * Sets the text in the url line edit box.
     *
     * \param text The new text.
     */
    void setUrlText(const QString &text) {
        lineEditUrl->setText(text);
    }

    /*!
     * Gets the text in the url line edit box.
     *
     * \return The text in the url line edit box.
     */
    QString urlText() {
        return lineEditUrl->text();
    }

    /*!
     * Sets the text in the image name format line edit box.
     *
     * \param text The new text.
     */
    void setImageNameFormatText(const QString &text) {
        lineEditImageNameFormat->setText(text);
    }

    /*!
     * Gets the text in the image name format line edit box.
     *
     * \return The text in the image name format line edit box.
     */
    QString imageNameFormatText() {
        return lineEditImageNameFormat->text();
    }

    //! Disables the dialog's OK button.
    void disableOkButton();

private slots:
    //! Enables the dialog's OK button.
    void enableOkButton();
};

#endif
