/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __DOWNLOADROUTEDIALOG_H__
#define __DOWNLOADROUTEDIALOG_H__

#include <QDialog>
#include <QString>
#include "ui_downloadroute.h"

//! A dialog used to download route data.
class DownloadRouteDialog : public QDialog, Ui::DownloadRouteDialog
{
    Q_OBJECT

public:
    /*!
     * Constructor.
     *
     * \param parent The parent widget (default = no parent).
     */
    DownloadRouteDialog(QWidget *parent = 0);

    //! Destructor.
    ~DownloadRouteDialog();

    /*!
     * Returns the text in the fromAddress line edit box.
     *
     * \return The fromAddress line edit box text.
     */
    QString getFromAddress() {
        return fromAddress->text();
    }

    /*!
     * Sets the text in the fromAddress line edit box.
     *
     * \param text The new text.
     */
    void setFromAddress(QString text) {
        fromAddress->setText(text);
    }

    /*!
     * Returns the text in the toAddress line edit box.
     *
     * \return The toAddress line edit box text.
     */
    QString getToAddress() {
        return toAddress->text();
    }

    /*!
     * Sets the text in the toAddress line edit box.
     *
     * \param text The new text.
     */
    void setToAddress(QString text) {
        toAddress->setText(text);
    }

private slots:
    //! Enables or disables the ok button.
    void enableOkButton();
};

#endif // __DOWNLOADROUTEDIALOG_H__
