/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __DOWNLOADPOISDIALOG_H__
#define __DOWNLOADPOISDIALOG_H__

#include "ui_downloadpois.h"

/*!
*Class for handling UI when downloading POIs.
*/
class DownloadPoisDialog : public QDialog, public Ui::DownloadPoisDialog
{
    Q_OBJECT

public:
    /*!
    * Constructor.
    * \param parent The parent widget of the dialog.
    */
    DownloadPoisDialog(QWidget *parent = 0);
    /*!
    * Destructor.
    */
    ~DownloadPoisDialog();

private slots:
    /*!
     * Enable or disable the ok button if a text field is empty.
     *
     * \param text The text in the field.
     */
    void enableOkButton(const QString &text);
};

#endif
