/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef DEFINITIONS_H_
#define DEFINITIONS_H_

#include <QtGlobal>

#include <QColor>
#include <QString>

#include "gpssatellitedata.h"
#include "maprepository.h"
#include <stdlib.h>


//! Number of map tiles to display at once at zoom level 1.
static const qint32 tilesDisplayedAtFirstZoomLevel = 4;

//! Number of tiles to display at once at zoom levels above 1.
static const int mapTileRows = 4;
static const int mapTileColumns = 5;
static const int tilesDisplayedAtHigherZoomLevels = mapTileRows *
        mapTileColumns;

const qreal mouseZoomLongitudeThreshold = 0.0015 * mapTileColumns;
const qreal mouseZoomLatitudeThreshold = 0.0015 * mapTileRows;

static const int mapTileWidth = 256;
static const int mapTileHeight = 256;

const int defaultSizeLimitForMapImages = 10 * 1024 * 1024; // = 10 Mb
const int defaultAmountOfImagesToRemove = 20;
const int gpsdDefaultPort = 2497;
const int defaultActiveRepository = 0;
const QColor defaultRouteLineColor = Qt::blue;
const int defaultRouteLineThickness = 5;
const int defaultDistanceToAlarm = 100;
const int defaultCountNearestPois = 5;
const int defaultRouteZoomLevel = 14;
const bool defaultAdvancedMode = false;

const int RMCTimeIndex = 0;
const int RMCStatusIndex = 1;
const int RMCLatitudeIndex = 2;
const int RMCNorthSouthIndex = 3;
const int RMCLongitudeIndex = 4;
const int RMCEastWestIndex = 5;
const int RMCSpeedIndex = 6;
const int RMCCourseIndex = 7;
const int RMCDateIndex = 8;
const int RMCMagneticVariationDegreesIndex = 9;
const int RMCMagneticVariationEastWestIndex = 10;
const int RCMFAAModeIndex = 11;
const int RCMCheckSumIndex = 12;

const qreal mercatorTop = 3.14159188886811;
const qreal mercatorSpan = -6.28318377773622;
const qreal pi = 3.1415926535;
const qreal knotsInKmPerHour = 1.852;

const QString validIndicatorString('A');
const QString south('S');
const QString west('W');

const QString DELIM(",");

const QString localHost("127.0.0.1");

const QString messageForGps("AT$GPSNMUN=1,1,0,1,1,1,0");
//const QString messageForGps("AT$GPSNMU");    //used to test error messages
const QString messageOkForGps("AT") ;
const QString messageErrorFromGps("ERROR") ;
const QString messageDownForGps("AT$GPSNMUN=0") ;
const QString messageShutDownForGps("AT#SHDN") ;

const QString defaultMapImageDirectory(QString("%1/.qtmapper/Images/").arg(getenv ("HOME")));
const int timeStringLength = 6;
const int hourStringLength = 2;

const int maxSatellitesCount = 12 ;
extern GpsSatelliteData gpsSatelliteDataArray[maxSatellitesCount];

extern bool enableGps ; // mm: _enable_gps
extern bool gpsInfo ; // mm: _gps_info
extern bool satelliteDetailsOn ; // maemomapper: _satdetails_on

const QString nmeaTypeGSV("GSV") ;
const QString nmeaTypeGGA("GGA") ;
const QString nmeaTypeGSA("GSA") ;
const QString nmeaTypeRMC("RMC") ;

const int minimumZoomLevelToDrawRoute = 5;

// Resource string constants.
static const QString
upButtonImageResource(":/resources/images/up.png");
static const QString
downButtonImageResource(":/resources/images/down.png");
static const QString
leftButtonImageResource(":/resources/images/left.png");
static const QString
rightButtonImageResource(":/resources/images/right.png");
static const QString
zoomUpButtonImageResource(":/resources/images/zoomin.png");
static const QString
zoomDownButtonImageResource(":/resources/images/zoomout.png");
static const QString
zoomInButtonIcon(":/resources/images/plusicon2.png");
static const QString
zoomOutButtonIcon(":/resources/images/minusicon2.png");
static const QString
zoomPoiButtonIcon(":/resources/images/nasta_icon.png");
static const QString
zoomTrackButtonIcon(":/resources/images/trackicon3.png");
static const QString
colorWhiteResource(":/resources/images/color_white.png");
static const QString
colorBlackResource(":/resources/images/color_black.png");
static const QString
colorRedResource(":/resources/images/color_red.png");
static const QString
colorDarkRedResource(":/resources/images/color_darkred.png");
static const QString
colorGreenResource(":/resources/images/color_green.png");
static const QString
colorDarkGreenResource(":/resources/images/color_darkgreen.png");
static const QString
colorBlueResource(":/resources/images/color_blue.png");
static const QString
colorDarkBlueResource(":/resources/images/color_darkblue.png");
static const QString
colorCyanResource(":/resources/images/color_cyan.png");
static const QString
colorDarkCyanResource(":/resources/images/color_darkcyan.png");
static const QString
colorMagentaResource(":/resources/images/color_magenta.png");
static const QString
colorDarkMagentaResource(":/resources/images/color_darkmagenta.png");
static const QString
colorYellowResource(":/resources/images/color_yellow.png");
static const QString
colorDarkYellowResource(":/resources/images/color_darkyellow.png");
static const QString
gpsFixInvalidIndicatorResource(":/resources/images/offline.png");
static const QString
gpsFixValidIndicatorResource(":/resources/images/online.png");
static const QString
moveToolResource(":/resources/images/movetool.png");
static const QString
stopDownloadResource(":/resources/images/cancel.png");
static const QString
zoomToolResource(":/resources/images/zoomtool.png");

typedef enum {
    GPS_RCVR_BT,
    GPS_RCVR_GPSD,
    GPS_RCVR_FILE,
    GPS_RCVR_ENUM_COUNT
} gpsReceiverType;

//! For showing POI or location marker.
typedef enum {
    infoTypeSearchedLocation,
    infoTypePoi

} InfoType;

// Default map repositories.
const MapRepository openStreetMap("OpenStreetMap",
                                  "http://tile.openstreetmap.org",
                                  "/%1/%2/%3",
                                  "openstreetmap.db",
                                  repositoryTypeZoomXY);

const MapRepository googleMapsStreet("Google Maps (street)",
                                     "http://mt1.google.com",
                                     "/mt?x=%1&y=%2&zoom=%3",
                                     "googlestreet.db",
                                     repositoryTypeXYZoom);
const MapRepository googleMapsSatellite("Google Maps (satellite)",
                                        "http://kh.google.com/kh?v=999&t=%s",
                                        "/%1/%2/%3",
                                        "googlesatellite.db",
                                        repositoryTypeXYZoom);

// String constants used with QSettings.
const QString settingOrganizationName("Souoxi");
const QString settingApplicationName("QtMapper");
const QString settingsizeLimitForMapImages("sizeLimitForMapImages");
const QString settingAmountOfImagesToRemove("amountOfImagesToRemove");
const QString settingMapImageDirectory("mapImageDirectory");
const QString settingMapRepositories("MapRepositories");
const QString settingRepositoryName("name");
const QString settingRepositoryUrl("url");
const QString settingRepositoryImageNameFormat("imageNameFormat");
const QString settingRepositoryDatabaseFileName("databaseFileName");
const QString settingActiveRepository("activeRepository");
const QString settingTemporaryImageDirectory("/tmp/");
const QString settingRouteLineColor("routeLineColor");
const QString settingRouteLineThickness("routeLineThickness");
const QString settingDistanceToAlarm("distanceToAlarm");
const QString settingCountNearestPois("countNearestPois");
const QString settingRouteZoomLevel("routeZoomLevel");
const QString settingAdvancedMode("advancedMode");
const QString settingTrackPoints("trackPoints");
const QString settingTrackPointLatitude("latitude");
const QString settingTrackPointLongitude("longitude");
const QString settingTrackPointTime("time");
const QString settingLastZoomLevel("lastZoomLevel");
const QString settingLastLongitudeInView("lastLongitude");
const QString settingLastLatitudeInView("lastLatitude");

#endif
