/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __BROWSEPOISDIALOG_H__
#define __BROWSEPOISDIALOG_H__

#include "ui_browsepois.h"
#include "poicategory.h"
#include "poi.h"
#include <QVector>
#include "QtMapper.h"

/*!
 * Class for representing and manipulating POI data of database.
 */
class BrowsePoisDialog : public QDialog, public Ui::BrowsePoisDialog
{
    Q_OBJECT

public:
   
    /*!
     * Constructor.
     *\param mainWindow a reference to QtMapper main application window
     *\param latitude current latitude as qreal
     *\param longitude current longitude as qreal
     *\param limit the maximum number of pois to be loaded
     *\param parent a pointer to parent widget
     */
    BrowsePoisDialog(QtMapper &mainWindow,
                     qreal latitude,
                     qreal longitude,
                     qint32 limit,
                     bool validGpsDataAvailable,
                     QWidget *parent = 0);

    //! Destructor
    ~BrowsePoisDialog();

private:

    //! Whether valid gps location data is available
    bool validGpsDataAvailable;

    //! Reference to the main window class
    QtMapper & mainWindow;

    //! Container for POI categories data.
    QVector<PoiCategory> categories;

    //! Container for POI data.
    QVector<Poi> * pois;

    //! Current latitude
    qreal latitude;

    //! Current longitude
    qreal longitude;

    //! Limit of POIs to be loaded.
    qint32 limit;

    //! Parameter for POI List Dialog
    qint32 selectedOption;

	//! Text for show button.
    const QString buttonTextShow;

	//! Text for search button.
    const QString buttonTextSearch;
    
    //! Pointer to POI database.
    PoiDatabase* poiDb;

    /*!
    *Shows dialog POI List when option use Gps location is selected.
    */
    void showPoiListDialogByGpsLocation();

    /*!
    *Shows dialog POI List when option use Search is selected.
    */
    void showPoiListDialogBySearch();

    /*!
    *Shows dialog POI List when option show all is selected.
    */
    void showPoiListDialogAll();

private slots:

    /*!
    *Checks which option is selected and calls appropriate function.
    */
    void showDialog();

    //! Changes the button text when radio button selection changes.
    void radioButtonSelectionChanged(QAbstractButton *button);
};

#endif
