/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __ADDPOIDIALOG_H__
#define __ADDPOIDIALOG_H__

class PoiDatabase;
class QString;


#include <QVector>
#include "poicategory.h"
#include "ui_editpoi.h"
#include "QtMapper.h"

/*!
 *Class for handling UI when adding data of POI category.
 */
class AddPoiDialog : public QDialog, public Ui::EditPoiDialog
{
    Q_OBJECT

public:
    /*!
    * Constructor.
    * \param mainWindow Reference to QtMapper
    * \param parent The parent widget of the dialog.
    */
    AddPoiDialog(QtMapper &mainWindow, QWidget *parent = 0);

    //! Destructor.
    ~AddPoiDialog();

    /*!
     * Set the contents of the latitude field.
     *
     * \param latitude The latitude value.
     */
    void setLatitudeContents(qreal latitude);

    /*!
     * Set the contents of the longitude field.
     *
     * \param latitude The longitude value.
     */
    void setLongitudeContents(qreal longitude);

    //! Gets the POI categories from database and puts them in the combo box.
    void setCategories();

    /*!
     * \brief Adds a new POI to the database.
     *
     * Creates a Poi object and initializes it with the values from the dialog
     * and inserts it into the POI database.
     */
    void addPoiToDatabase();

private:
    //! POI category data container
    QVector<PoiCategory> categories;

    /*!
     * Sets labels of POI categories to the combobox.
     */
    void setData();

    //! Selected index of Category comboBox
    qint32 selectedIndex;
   	
    //! Reference to main window.
    QtMapper &mainWindow;

    //! Pointer to POI database.
    PoiDatabase *poiDb;

    //! Minimum allowed latitude value
    const qreal minLatitude;

    //! Maximum allowed latitude value
    const qreal maxLatitude;

    //! Minimum allowed longitude value
    const qreal minLongitude;

    //! Maximum allowed longitude value
    const qreal maxLongitude;

    //! Maximum number of decimals to use with latitude/longitude values.
    const qint32 maxDecimals;

    //! Window title
    const QString windowTitle;

private slots:
    /*!
    * Shows Dialog POI categories.
    */
    void showPoiCategoriesDialog();

    /*!
     * \brief Enables the dialog's OK-button.
     *
     * When the name of the POI, i.e. lineEditLabel is not empty, this slot will
     * enable the dialogs OK-button. If the name is empty, the OK-button
     * becomes disabled.
     *
     * \param poiName The name of the POI given by user
     */
    void checkLabel(const QString &poiName);

    /*!
     * \brief Overrides buttongroup's accept slot.
     *
     * This function checks lat/lon input validation.
     */
    void accept() ;
};

#endif
