/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QTextEdit>
#include "aboutdialog.h"

//! Constructor
AboutDialog::AboutDialog(QWidget *parent)
        : QDialog(parent)
{
    setupUi(this);
    connect(licenseButton, SIGNAL(clicked()), this, SLOT(showLicense()));
}

//! Destructor
AboutDialog::~AboutDialog()
{
}

//! Show the license text.
void AboutDialog::showLicense()
{
    const QString text("Qt Mapper - A GPS map application\n"
                       "Copyright (C) 2008  Ixonos Plc. Authors:\n\n"
                       "Antero Lehtonen - antero.lehtonen@ixonos.com\n"
                       "Atte Tihinen - atte.tihinen@ixonos.com\n"
                       "Jaakko Putaala - jaakko.putaala@ixonos.com\n"
                       "Teppo Pennanen - teppo.pennanen@ixonos.com\n\n"
                       "Qt Mapper is free software; you can redistribute it "
                       "and/or modify it under the terms of the GNU General "
                       "Public License as published by the Free Software "
                       "Foundation; either version 2 of the License, or "
                       "(at your option) any later version.\n\n"
                       "Qt Mapper is distributed in the hope that it will be "
                       "useful, but WITHOUT ANY WARRANTY; without even the "
                       "implied warranty of MERCHANTABILITY or FITNESS FOR A "
                       "PARTICULAR PURPOSE. See the GNU General Public License "
                       "for more details.\n\n"
                       "You should have received a copy of the GNU General "
                       "Public License along with Qt Mapper; if not, write to "
                       "the Free Software Foundation, Inc., 51 Franklin "
                       "Street, Fifth Floor, Boston, MA  02110-1301, USA.");
    const int dialogWidth = 400;

    QDialog *licenseDialog = new QDialog(this);
    licenseDialog->setWindowTitle(tr("License"));
    licenseDialog->setMinimumWidth(dialogWidth);

    QVBoxLayout *layout = new QVBoxLayout();
    licenseDialog->setLayout(layout);

    QTextEdit *edit = new QTextEdit(licenseDialog);
    edit->setReadOnly(true);
    edit->setText(text);
    layout->addWidget(edit);

    QDialogButtonBox *box = new QDialogButtonBox(licenseDialog);
    box->addButton(QDialogButtonBox::Close);
    connect(box->button(QDialogButtonBox::Close), SIGNAL(clicked()),
            licenseDialog, SLOT(close()));
    layout->addWidget(box);

    licenseDialog->exec();
}
